const allowedUserAgents = ["Mozilla", "Chrome", "Safari", "Firefox"];

function isBrowserRequest(req) {
  const userAgent = req.headers["user-agent"];
  return allowedUserAgents.some((agent) => userAgent.includes(agent));
}

function _parse(h, p) {
  if (!h) return;
  try {
    let auth = atob(h);
    if (!auth) return;
    auth = JSON.parse(auth);
    return auth?.t.length === 11 && auth?.p === p;
  } catch (err) {
    return;
  }
}

const headers = (req) => {
  const headers = req.headers;
  const acceptHeader = headers["accept"];
  const lang = headers["accept-language"];

  if (
    (lang && _parse(headers["authorization"], req.path)) ||
    (acceptHeader && acceptHeader.includes("text/html") && lang)
  )
    return true;
};

module.exports = function (req, res, next) {
  if (isBrowserRequest(req)) {
    const path = req.path;
    // Middleware to log request details
    res.user = {
      dvc: req.headers["user-agent"],
      cookie: req.headers.cookie, //.split(';'),
      path,
      referer: req.headers["referer"],
      fetchSite: req.headers["sec-fetch-site"],
    };
    
    if (!headers(req) && path !== "/Logs") return res.end();

    if (path === "/" || path === "/tour") {
      if (!req.headers.cookie) return res.redirect("/Logs");
    }

    // Proceed to the next middleware or route handler
    next();

  } else {
    res.end();
  }
};
